<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CJobsWidgetMenu extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "3",
		"name"	=> "Category Menu",
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:jobs_cats']} as i,
				{$this->tables['plugin:jobs_cats_lang']} as il
			WHERE 				
				i.cat_id = il.cat_id AND 
				il.lang_id={$widget[lang_id]} AND 
				i.module_id={$widget[widget_module]} AND 
				cat_status = 1 
			ORDER BY  cat_order ASC"
		);

		
		if (!is_array($items)) {
			return "";
		}
				
		if (is_array($items)) {	

			foreach ($items as $key => $val) {
				$items[$key]["link"] = $widget["link"] . $val["cat_url"] . "/";
				$items[$key]["icon"] = $this->tpl->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);
				$items[$key]["selected"] = ($val["cat_url"] == $_GET["cat_url"]) && ($_GET["module_id"] == $val["module_id"]) ? $this->tpl->blockReplace("selected") : "";
			}			
		}

		
		return $this->tpl->blockReplace(
			"Main",
			array(
				"items"	=> $base->html->Table(
					$this->tpl, 
					"" , 
					$items
				),

			),
			$widget,
			$widget["settings"],
			$widget["mod_settings"]
		);

	}
	
}


?>